/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.data.game.constants;

import info.msxlaunchers.openmsx.common.NumericalEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum Genre implements NumericalEnum
{
    UNKNOWN("", 0),
    ACTION("Action", 1),
    ADULT("Adult", 2),
    ADVENTURE_ALL("Adventure (All)", 3),
    ADVENTURE_POINT_AND_CLICK("Adventure | Point and Click", 4),
    ADVENTURE_TEXT_AND_GFX("Adventure | Text and Gfx", 5),
    ADVENTURE_TEXT_ONLY("Adventure | Text only", 6),
    ARCADE("Arcade", 7),
    BOARD_GAMES("Board Games", 8),
    BREAK_OUT("Break-out", 9),
    CARD_GAMES("Card Games", 10),
    COMMUNICATION("Communication", 11),
    COMPILER("Compiler", 12),
    DATABASE("Database", 13),
    DTP("DTP", 14),
    EDUCATIONAL("Educational", 15),
    FIGHTING("Fighting", 16),
    FINANCIAL("Financial", 17),
    GAMBLING_FRUIT_MACHINE("Gambling / Fruit Machine", 18),
    GRAPHICS("Graphics", 19),
    MISCELLANEOUS("Miscellaneous", 20),
    OFFICE("Office", 21),
    OPERATING_SYSTEM("Operating System", 22),
    PARODY("Parody", 23),
    PINBALL("Pinball", 24),
    PLATFORM("Platform", 25),
    PUZZLE("Puzzle", 26),
    QUIZ("Quiz", 27),
    RACING("Racing", 28),
    REMAKE("Remake", 29),
    RPG("RPG", 30),
    SHOOT_EM_UP_ALL("Shoot-'em-up (All)", 31),
    SHOOT_EM_UP_FIRST_PERSON_SHOOTER("Shoot-'em-up | First-person shooter", 32),
    SHOOT_EM_UP_HORIZONTAL("Shoot-'em-up | Horizontal", 33),
    SHOOT_EM_UP_ISOMETRIC("Shoot-'em-up | Isometric", 34),
    SHOOT_EM_UP_MULTI_DIRECTIONAL("Shoot-'em-up | Multi-directional", 35),
    SHOOT_EM_UP_MULTI_VERTICAL("Shoot-'em-up | Vertical", 36),
    SIMULATION("Simulation", 37),
    SOUND("Sound", 38),
    SPORT_GAMES("Sport Games", 39),
    SPORT_MANAGEMENT("Sport Management", 40),
    SPREADSHEET("Spreadsheet", 41),
    STRATEGY("Strategy", 42),
    TOOL("Tool", 43),
    VARIETY("Variety", 44),
    WAR_GAMES("War Games", 45),
    WORD_PROCESSOR("Word Processor", 46),
    MAZE("Maze", 47),
    PONG("Pong", 48),
    BEAT_EM_UP("Beat-'em-up", 49),
    DEXTERITY("Dexterity", 50);

    private final String displayName;
    private final int value;
    private static List<Genre> valuesList;

    private Genre(String displayName, int value) {
        this.displayName = displayName;
        this.value = value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static Genre fromValue(int value) {
        int valueOrDefault = value;
        if (valueOrDefault < 0 || valueOrDefault > Genre.values().length - 1) {
            valueOrDefault = 0;
        }
        return valuesList.get(valueOrDefault);
    }

    static {
        valuesList = new ArrayList<Genre>(Genre.values().length);
        for (Genre genre : Genre.values()) {
            valuesList.add(genre);
        }
        valuesList = Collections.unmodifiableList(valuesList);
    }
}

